/****************************************************************************
 *   $Id:: lpc11U6x_rtc.h 3635 2010-06-02 00:31:46Z usb00423                $
 *   Project: NXP LPC11U6x RTC example
 *
 *   Description:
 *     This file contains definition and prototype for RTC 
 *     configuration.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#ifndef __RTC_H 
#define __RTC_H

#define USE_RTC_WAKE_CLK		0

/* Control register bit definition. */
#define RTC_SWRESET 				(0x1<<0)
#define RTC_OFD     				(0x1<<1)
#define RTC_ALARM1HZ				(0x1<<2)
#define RTC_WAKE1KHZ  			(0x1<<3)
#define RTC_ALARMDPD_EN 		(0x1<<4)
#define RTC_WAKEDPD_EN			(0x1<<5)
#define RTC1KHZ_EN  				(0x1<<6)
#define RTC1HZ_EN   				(0x1<<7)

void RTC_IRQHandler(void);
void init_rtc( void );
uint32_t get_rtc_count(void);
void enable_rtc_alarm(uint32_t timerInterval);
void enable_rtc_wake(uint32_t timerInterval);
int set_rtc_time(uint32_t year, uint32_t month, uint32_t day, uint32_t hour, uint32_t minute, uint32_t second);

#endif /* end __RTC_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
